import time

def BucketSort(array):
    if len(array) <= 1:
        return array

    # Mencari nilai maksimum dan minimum dalam array
    max_val = max(array)
    min_val = min(array)

    # Menentukan ukuran setiap range
    range_size = 10
    num_ranges = ((max_val - min_val) // range_size) + 1

    # Inisialisasi array kosong untuk setiap range
    ranges = [[] for i in range(num_ranges)]

    # Memasukkan setiap elemen ke dalam range yang sesuai
    for val in array:
        range_index = (val - min_val) // range_size
        ranges[range_index].append(val)

    # Memanggil selectionSort hybrid untuk setiap range
    sorted_ranges = []
    for i in range(num_ranges):
        print("Bucket", i+1, "sebelum diurutkan:", ranges[i])
        sorted_range = selectionSortHybrid(ranges[i])
        sorted_ranges.extend(sorted_range)
        print("Bucket", i+1, "setelah diurutkan:", sorted_range)
        print()

    return sorted_ranges


def selectionSortHybrid(array):
    left = 0
    right = len(array) - 1
    while left < right:
        minIndex = left
        maxIndex = right
        for i in range(left, right + 1):
            if array[i] < array[minIndex]:
                minIndex = i
            if array[i] > array[maxIndex]:
                maxIndex = i
        array[left], array[minIndex] = array[minIndex], array[left]
        if left == maxIndex:
            maxIndex = minIndex
        array[right], array[maxIndex] = array[maxIndex], array[right]
        left += 1
        right -= 1
    return array

# Meminta input deret dari pengguna
input_str = input("Masukkan deret angka, dipisahkan oleh spasi: ")
input_list = input_str.split()
array = [int(x) for x in input_list]

# Memulai hitung waktu eksekusi
start_time = time.time()

# Memanggil fungsi rangeSort
sorted_array = BucketSort(array)

# Menghitung waktu eksekusi
elapsed_time = time.time() - start_time

# Menampilkan hasil pengurutan dan waktu eksekusi
print("Hasil pengurutan: ", end="")
for val in sorted_array:
    print(val, end=" ")
print()
print("Waktu eksekusi:", elapsed_time, "detik")